package org.msh.etbm.services.mobile.init;

import org.jboss.seam.Component;
import org.msh.etbm.services.mobile.InitDataGenerator;
import org.msh.etbm.services.mobile.model.AdminUnitData;
import org.msh.tb.entities.Tbunit;
import org.msh.tb.entities.Workspace;
import org.msh.tb.login.UserSession;

import javax.persistence.EntityManager;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by rmemoria on 15/4/17.
 */
public class Step1InitGenerator implements InitDataGenerator<List<AdminUnitData>> {


    @Override
    public List<AdminUnitData> generate(Tbunit unit) {
        // load the admin units
        List<Object[]> lst = loadData();

        // convert to the final data
        List<AdminUnitData> res = new ArrayList<AdminUnitData>();
        for (Object[] data: lst) {
            res.add(marshal(data));
        }

        return res;
    }


    public AdminUnitData marshal(Object[] vals) {
        AdminUnitData data = new AdminUnitData();
        data.setId((Integer)vals[0]);
        data.setName((String)vals[1]);
        data.setParentId((Integer)vals[2]);
        data.setUnitsCount((Integer)vals[3]);
        data.setCode((String)vals[4]);

        return data;
    }

    public List<Object[]> loadData() {
        EntityManager em = (EntityManager)Component.getInstance("entityManager");
        Workspace ws = UserSession.getWorkspace();

        return em.createQuery("select id, name.name1, parent.id, unitsCount, code from AdministrativeUnit " +
                "where workspace.id = :id " +
                "order by code")
                .setParameter("id", ws.getId())
                .getResultList();
    }
}
